<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Background + Logo direita - cima</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .backdrop-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1; /* Ensure backdrop is behind other elements */
        }
        .backdrop {
            width: 100%;
            height: 100%;
            object-fit: cover;
            opacity: 0;
            transition: opacity 1.5s; /* Fade in/out effect */
        }
        .poster-container {
            position: absolute;
            top: 30px;
            right: 30px;
            z-index: 1;
            padding: 10px;
            border-radius: 5px;
            color: #fff;
            max-width: 250px;
            text-align: center;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 10px;
            background-color: rgba(0, 0, 0, 0.8);
            border-radius: 10px;
            padding: 20px;
            opacity: 0;
            transition: opacity 1.5s; /* Fade in/out effect */
        }
    </style>
</head>
<body>
    <div class="backdrop-container">
        <img id="backdrop" class="backdrop">
    </div>
    <div class="poster-container">
        <img id="poster" class="poster">
        <img id="logo" class="logo">
        <div id="movie-info" class="movie-info"></div>
    </div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2';
        let currentIndex = 0;
        let movieIds = [];

        async function fetchPopularEnglishMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=pt`);
                if (!response.ok) {
                    throw new Error('Failed to fetch popular English movies');
                }
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Error fetching popular English movies:', error);
            }
        }

        async function fetchMovieBackdrop(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie backdrop');
                }
                const data = await response.json();
                const backdropPath = data.backdrops[0].file_path; // Assuming the first backdrop in the array
                return `https://image.tmdb.org/t/p/original${backdropPath}`;
            } catch (error) {
                console.error('Error fetching movie backdrop:', error);
            }
        }

        async function fetchMovieLogo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&append_to_response=images`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie logo');
                }
                const data = await response.json();
                const logos = data.images.logos;
                const englishLogo = logos.find(logo => logo.iso_639_1 === 'pt');
                if (englishLogo) {
                    return `https://image.tmdb.org/t/p/w500${englishLogo.file_path}`;
                } else {
                    return null;
                }
            } catch (error) {
                console.error('Error fetching movie logo:', error);
            }
        }

        async function updateBackdropPosterLogoAndInfo() {
            if (movieIds.length === 0) {
                console.error('No movie IDs available.');
                return;
            }

            const movieId = movieIds[currentIndex];

            try {
                const backdrop = document.getElementById('backdrop');
                const logo = document.getElementById('logo');

                // Fade out
                backdrop.style.opacity = 0;
                logo.style.opacity = 0;

                setTimeout(async () => {
                    const backdropUrl = await fetchMovieBackdrop(movieId);
                    if (backdropUrl) {
                        backdrop.src = backdropUrl;
                    }

                    const logoUrl = await fetchMovieLogo(movieId);
                    if (logoUrl) {
                        logo.src = logoUrl;
                    }

                    // Fade in
                    backdrop.style.opacity = 1;
                    logo.style.opacity = 1;

                    currentIndex = (currentIndex + 1) % movieIds.length;
                }, 1500); // Time to wait for fade out before changing images
            } catch (error) {
                console.error('Error updating backdrop and logo:', error);
            }
        }

        fetchPopularEnglishMovieIds().then(() => {
            setInterval(updateBackdropPosterLogoAndInfo, 6000); // Change backdrop, poster, logo, and movie info every 10 seconds (adjust as needed)
            updateBackdropPosterLogoAndInfo(); // Initial update
        });
    </script>
</body>
</html>
